/* ============ */
/* anlzpmtn.c	*/
/* ============ */
#include <stdio.h>
#include <stdlib.h>
#include <pmtndefs.h>

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
static	int	AlreadyHaveValue F((int *, int, int));
extern	int	AnalyzeNextPermutation F((PRMUT_DATA_STRU *));
static	int	MaxOf F((int *, int));

# undef F
/* INDENT ON */

#define	SWAP_INT(T, a, b)	\
     {				\
	int	x = T[a];	\
	T[a] = T[b];		\
	T[b] = x;		\
     }
#define	PRINT_TABLE(T, n)	                \
    {				                \
	int	k;                              \
	for (k = 1; k <= n; ++k)                \
	{                                       \
	    P(printf("\t%5d%10d\n", k, T[k-1]));	\
	}                       		\
    }
/* ==================================================================== */
/* AnalyzeNextPermutation - Converts t random numbers to unique number	*/
/* ==================================================================== */
int
AnalyzeNextPermutation(PRMUT_DATA_STRU *PermuteData)
{
    int     k;
    int     NextNum, UniqNum = 0;
    int     UniqTbl[MAX_ELEMS];

    for (k = 0; k < PermuteData->NumElements; ++k)
    {
	do
	{
	    NextNum = PermuteData->RandFun();
	    ++PermuteData->NumVariates;
	}
	while (AlreadyHaveValue(UniqTbl, k, NextNum));

	P(printf("NextNum = %5d\n", NextNum));
	UniqTbl[k] = NextNum;
    }

    P(printf("Before Transformation: Table =\n"));
    PRINT_TABLE(UniqTbl, PermuteData->NumElements);
    for (k = PermuteData->NumElements; k > 1; --k)
    {
	int	s = MaxOf(UniqTbl, k);
	UniqNum = k * UniqNum + s;
	SWAP_INT(UniqTbl, k-1, s);
    }
    P(printf("After  Transformation: Table =\n"));
    PRINT_TABLE(UniqTbl, PermuteData->NumElements);

    return (UniqNum);
}
/* ==================================================================== */
/* AlreadyHaveValue - Returns true if number at Value is in Table	*/
/* ==================================================================== */
static
int	AlreadyHaveValue(int *Table, int NumElems, int Value)
{
    int     k;

    for (k = NumElems; k >= 1; --k)
    {
	if (Table[k-1] == Value)
	{
	    break;
	}
    }
    P(printf("AlreadyHaveValue Returning %s\n",
	(k > 0) ? "TRUE" : "FALSE"));

    return (k);
}
/* ==================================================================== */
/* MaxOf - Returns Index of Maximum Value in Table of NumElems Elements	*/
/* ==================================================================== */
static
int	MaxOf(int *Table, int NumElems)
{
    int  j, k, Max;
    j = 0;
    Max = *Table;
    for (k = 1; k < NumElems; ++k)
    {
	if (Max < Table[k])
	{
	    j = k;
	    Max = Table[k];
	}
    }
    P(printf("MaxOf Returning %5d, Max = %5d\n", j, Table[j]));
    return j;
}
